<?php

namespace App\Imports;

use App\Models\Client;
use App\Models\Clientsinfo;
use App\Models\MikcrotikClientList;
use App\Models\Packages;
use App\Models\Pop;
use App\Models\ReselleBalanceLogReport;
use App\Models\SubPackage;
use App\Models\SubResellerBalanceLogReport;
use Carbon\Carbon;
use DateTime;
use Exception;
use Facade\Ignition\Support\Packagist\Package;
use GuzzleHttp\Promise\Create;
use Maatwebsite\Excel\Concerns\Importable;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Throwable;

class ClientsImport implements ToCollection
{
    use Importable;
    public function collection(Collection $rows)
    {
        $count = 0;
        foreach ($rows as $row) {
            if ($count > 0) {
                try{
                    $client = Client::where('userid', $row[0])->first();
                    $subpackage = SubPackage::where('name', $row[2])->first();
                    $pop = Pop::where('popname', $row[3])->first();



                    if($client){

                        $client->package_id = $subpackage->package_id;
                        $client->sub_package_id = $subpackage->id;
                        $client->pop_id = $pop->id;
                        $client->save();

                        $clientinfo = Clientsinfo::where('client_id', $client->id)->first();
                        $clientinfo->contact_no = $row[1];
                        $clientinfo->save();
                    }

                }catch(Exception $e){
                    dd($e, $count,$client);
                }

            }
            $count++;
        }
    }
}
