@extends('layout.app')
@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('employees.update', $employee->id) }}" method="POST">
                @method('PUT')
                @csrf
                <div class="row">

                    <div class="col-md-4">
                        <label for="user_id">
                            Application User ID <span style="color: red">*</span>
                        </label>
                        <input type="number" name="user_id" id="user_id" value="{{ $employee->user_id }}"
                            class="form-control" placeholder="user_id" required>
                        @error('user_id')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label for="name">
                            Employee Name <span style="color: red">*</span>
                        </label>
                        <input type="text" name="name" id="name" value="{{ $employee->name }}" class="form-control"
                            placeholder="Reseller Name" autocomplete="off" required>
                        @error('name')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label for="admin_user_id">Select Admin User</label>
                        @if ($employee->admin_user_id != null)
                            <div class="row">
                                <div class="col-md-4">
                                    <span class="text-primary">
                                    {{ $employee->admin->name ?? '' }}</span>
                                </div>
                                <div class="col-md-8">
                                    @can('change-employee-admin-user')
                                        <select name="admin_user_id" id="admin_user_id" class="form-control select2">
                                            <option value="">Select One</option>
                                            @forelse ($changeUser as $item)
                                                <option value="{{$item->id}}"{{$item->id == $employee->admin_user_id ? 'selected' : ''}}>{{$item->name}}</option>
                                            @empty
                                            @endforelse
                                        </select>
                                    @endcan
                                </div>
                            </div>
                        @else
                            <select class="form-control select2" name="admin_user_id" id="">
                                <option value="">Select One</option>
                                    @forelse ($allUser as $user)
                                        <option value="{{$user->id}}" {{ $user->id == $employee->admin_user_id ? 'selected' : ''}}>{{$user->name}}</option>
                                    @empty
                                    @endforelse
                            </select>
                        @endif
                    </div>
                    <div class="col-md-4">
                        <label for="hr_name">
                            HR Name
                        </label>
                        <input type="text" name="hr_name" id="name" value="{{ $employee->hr_name }}"
                            class="form-control" placeholder="HR Name" autocomplete="off">
                        @error('hr_name')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label for="join_date">
                            Join Date
                        </label>
                        <input type="date" name="join_date" id="join_date" class="form-control" placeholder="  Join Date"
                            value="{{ \Carbon\Carbon::parse($employee->join_date)->format('Y-m-d')}}" autocomplete="off">
                        @error('join_date')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>


                    <div class="col-md-4">
                        <label for="date_of_birth">
                            Date of Birth
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="date" name="date_of_birth" id="date_of_birth" class="form-control"
                                placeholder="  Join Date" value="{{ $employee->date_of_birth }}" autocomplete="off">
                        </div>
                        @error('date_of_birth')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>



                    <div class="col-md-4">
                        <label for="joining_designation">
                            Joining Designation
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="text" name="joining_designation" id="joining_designation" class="form-control"
                                placeholder="joining designation" value="{{ $employee->joining_designation }}"
                                autocomplete="off">
                        </div>
                        @error('joining_designation')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>


                    <div class="col-md-4">
                        <label for="current_designation">
                            Current Designation
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="text" name="current_designation" id="current_designation" class="form-control"
                                placeholder="Current Designation" value="{{ $employee->current_designation }}"
                                autocomplete="off">
                        </div>
                        @error('current_designation')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>


                    <div class="col-md-4">

                        <label for="department">
                            Department
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="text" name="department" id="remark" class="form-control" placeholder="Department"
                                value="{{ $employee->department }}" autocomplete="off">
                        </div>
                        @error('department')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="col-md-4">

                        <label for="father">
                            Father
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="text" name="father" id="father" class="form-control" placeholder="Father"
                                value="{{ $employee->father }}" autocomplete="off">
                        </div>
                        @error('father')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="col-md-4">

                        <label for="mother">
                            Mother
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="text" name="mother" id="mother" class="form-control" placeholder="Mother"
                                value="{{ $employee->mother }}" autocomplete="off">
                        </div>
                        @error('mother')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="col-md-4">

                        <label for="appointment_date">
                            Appointment Date
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="date" name="appointment_date" id="appointment_date" class="form-control"
                                placeholder="Appointment Date" value="{{ $employee->appointment_date }}"
                                autocomplete="off">
                        </div>
                        @error('appointment_date')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="col-md-4">

                        <label for="joining_salary">
                            Joining Salary
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="text" name="joining_salary" id="joining_salary" class="form-control"
                                placeholder="joining_salary" value="{{ $employee->joining_salary }}" autocomplete="off">
                        </div>
                        @error('joining_salary')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="col-md-4">

                        <label for="current_salary">
                            Current Salary
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="text" name="current_salary" id="current_salary" class="form-control"
                                placeholder=" Current Salary" value="{{ $employee->current_salary }}" autocomplete="off">
                        </div>
                        @error('current_salary')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="col-md-4">

                        <label for="last_promotion_increment_date">
                            Last Promotion Increment Date
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="date" name="last_promotion_increment_date" id="last_promotion_increment_date"
                                class="form-control" placeholder="Last Promotion Increment Date"
                                value="{{ $employee->last_promotion_increment_date }}" autocomplete="off">
                        </div>
                        @error('last_promotion_increment_date')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="col-md-4">

                        <label for="current_address">
                            Current Address
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="text" name="current_address" id="current_address" class="form-control"
                                placeholder="Current Address" value="{{ $employee->current_address }}"
                                autocomplete="off">
                        </div>
                        @error('current_address')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="col-md-4">

                        <label for="permanent_address">
                            Permanent Address
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="text" name="permanent_address" id="permanent_address" class="form-control"
                                placeholder="Permanent  Address" value="{{ $employee->permanent_address }}"
                                autocomplete="off">
                        </div>
                        @error('permanent_address')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="col-md-4">

                        <label for="mobile_office">
                            Mobile Number
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="text" name="mobile_office" id="mobile_office" class="form-control"
                                placeholder="Mobile Number" value="{{ $employee->mobile_office }}" autocomplete="off" required>
                        </div>
                        @error('mobile_office')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="col-md-4">

                        <label for="mobile_personal">
                            Mobile Personal
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="text" name="mobile_personal" id="mobile_personal" class="form-control"
                                placeholder="Mobile Personal" value="{{ $employee->mobile_personal }}"
                                autocomplete="off">
                        </div>
                        @error('mobile_personal')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="col-md-4">

                        <label for="family">
                            Family
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="text" name="family" id="family" class="form-control" placeholder="Family"
                                value="{{ $employee->family }}" autocomplete="off">
                        </div>
                        @error('family')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="col-md-4">

                        <label for="reference">
                            Reference
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="text" name="reference" id="reference" class="form-control"
                                placeholder="Reference" value="{{ $employee->reference }}" autocomplete="off">
                        </div>
                        @error('reference')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="col-md-4">

                        <label for="nid">
                            NID
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="text" name="nid" id="nid" class="form-control" placeholder="NID"
                                value="{{ $employee->nid }}" autocomplete="off">
                        </div>
                        @error('nid')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="col-md-4">

                        <label for="manager_id">
                            Manager ID
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="number" name="manager_id" id="manager_id" class="form-control"
                                placeholder="Manager ID" value="{{ $employee->manager_id }}" autocomplete="off">
                        </div>
                        @error('manager_id')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="col-md-4">

                        <label for="employee_can_requisite">
                            Employee Can Requisite
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">
                            <select name="employee_can_requisite" id="employee_can_requisite" class="form-control select2">
                                <option value="Yes">Yes</option>
                                <option value="No">No</option>
                            </select>
                        </div>
                        @error('employee_can_requisite')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>


                    <div class="col-md-4">

                        <label for="status">
                            Status <span style="color: red">*</span>
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <select name="status" id="status" class="form-control select2" required>
                                <option value="">Select Status</option>
                                <option value="active" @if ($employee->status == 'active') selected @endif>Active</option>
                                <option value="pending" @if ($employee->status == 'pending') selected @endif>Pending</option>
                            </select>
                        </div>
                        @error('status')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="col-md-12">

                        <label for="remark">
                            Remark
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <input type="text" name="remark" id="remark" class="form-control" placeholder="Remark"
                                value="{{ $employee->remark }}" autocomplete="off">
                        </div>
                        @error('remark')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="col-md-12 mt-2">
                        <button class="btn btn-primary float-right" type="submit">
                            Update</button>
                    </div>

                </div>

            </form>

        </div>
    @endsection
