<?php

namespace App\Http\Controllers;

use App\Models\Employee;
use App\Models\Payroll;
use Carbon\Carbon;
use Illuminate\Http\Request;

class PayrollController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('payroll.salarysheet.index',[
            'salarySheets' => Payroll::with('employee')->whereMonth('created_at', Carbon::now()->month)->get(),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Payroll  $payroll
     * @return \Illuminate\Http\Response
     */
    public function show(Payroll $payroll)
    {
        dd('payroll');
        $salarySheet = Payroll::with('employee')->findOrFail($id);
        return response()->json($salarySheet);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Payroll  $payroll
     * @return \Illuminate\Http\Response
     */
    public function edit(Payroll $payroll)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Payroll  $payroll
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Payroll $payroll)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Payroll  $payroll
     * @return \Illuminate\Http\Response
     */
    public function destroy(Payroll $payroll)
    {
        //
    }

    public function salaryGenerate()
    {
        // dd('salaryGenerate');
        $employees = Employee::where('salary_generate', 1)->get();

        foreach ($employees as $employee) {
            $generatedSalaryEmployee = Payroll::where('employee_id', $employee->id)->whereMonth('created_at', Carbon::now()->month)->first();


            $previousMonthInfo = Payroll::where('employee_id', $employee->id)->whereMonth('created_at', Carbon::now()->subMonth())->first();


            if ($previousMonthInfo) {
                $previousMonth = $previousMonthInfo->salary_amount;
            }else {
                $previousMonth = 0;
            }

            $salary = $employee->current_salary + $employee->house_allowance + $employee->transport_allowance + $employee->other_allowance;
            // dd($salary);
            $net_salary = ((($salary/30)*(30 - $employee->absent_day)) + $employee->bonous) - $employee->advance_salary;

            // dd($net_salary);

            if ($generatedSalaryEmployee) {
                $generatedSalaryEmployee->employee_id = $employee->id;
                $generatedSalaryEmployee->salary = $employee->current_salary;
                $generatedSalaryEmployee->home_allowance = $employee->house_allowance ?? 0;
                $generatedSalaryEmployee->transport_allowance = $employee->transport_allowance ?? 0;
                $generatedSalaryEmployee->other_allowance = $employee->other_allowance ?? 0;
                $generatedSalaryEmployee->bonous = $employee->bonous ?? 0;
                $generatedSalaryEmployee->deduction = $employee->advance_salary ?? 0;
                $generatedSalaryEmployee->net_salary = $net_salary;
                $generatedSalaryEmployee->salary_amount = $previousMonth + $net_salary;
                $generatedSalaryEmployee->save();
            }
            else{
                $payroll = new Payroll();

                $payroll->employee_id = $employee->id;
                $payroll->salary = $employee->current_salary;
                $payroll->home_allowance = $employee->house_allowance ?? 0;
                $payroll->transport_allowance = $employee->transport_allowance ?? 0;
                $payroll->other_allowance = $employee->other_allowance ?? 0;
                $payroll->bonous = $employee->bonous ?? 0;
                $payroll->deduction = $employee->advance_salary ?? 0;
                $payroll->net_salary = $net_salary;
                $payroll->salary_amount = $previousMonth->salary_amount + $net_salary;
                $payroll->save();
            }

        }


        return redirect()->route('payroll.index');
    }

    public function salarySheet($id)
    {
        // dd('salarySheet');
        $salarySheet = Payroll::with('employee')->where('employee_id', $id)->whereMonth('created_at', Carbon::now()->month)->first();
        return $salarySheet;
    }
}
