<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class AllClientExport implements FromCollection, WithHeadings, ShouldAutoSize
{

    protected $data, $array;

    function __construct($data)
    {
        $this->data = $data;
    }

    public function headings(): array
    {
        return [
            'cid',
            'pop_id',
            'billing_cycle',
            'package_id',
            'userid',
            'password',
            'ip_address',
            'expire_date',
            'payment_dadeline',
            'created_by',
            'client_approval',
            'created_at',
            'clients_status',
            'sub_package_id',
            'customer_id',
            'marketed_by',
            'deleted_at',
            'parmanent_discount',
            'required_cable',
            'ignoreMKCheck',
            'closed_at',
            'bandwidth_limit',
            'up_bandwidth',
            'down_bandwidth',
            'isStatic',
            'auto_deactive',
            'clients_name',
            'father_name',
            'mother_name',
            'flat_no',
            'building_name',
            'road_no',
            'block_sector',
            'area',
            'district',
            'thana',
            'contact_no',
            'national_id',
            'email',
            'passport_no',
            'created_at',
            'updated_at',
            'owner_name',
            'owner_number',
            'olt_pon',
            'otc',
            'building_no',
            'remarks',
            'dob',
            'cable_type',
            'road_name',
            'otc_due',
            'profilePicture',
            'other_contact',
            'box',
            'joinDate',
            'client_latitude',
            'client_longitude',
            'picture',
            'client_door',
            'cat_type',
            'cat_length',
            'olt_no',
            'pon_port',
            'onu_serial',
            'customer_profile_picture',
            'from_cable',
            'to_cable',
            'customer_agrement',
            'cable_id',
            'customer_package_name',
            'btrc_package_bandwidth',
            'from_cable2',
            'to_cable2',
            'source_name',
            'division'
        ];
    }

    public function collection()
    {
        $items = [];
        foreach ($this->data as $client) {
            // dd($client);

            $items[] = [
                $client->id,
                $client->pop->popname ?? '',
                $client->billing_cycle,
                $client->packages->package_name ?? '',
                $client->userid,
                $client->password,
                $client->ip_address,
                $client->expire_date,
                $client->payment_dadeline,
                $client->created_by,
                $client->client_approval,
                $client->created_at,
                $client->clients_status,
                $client->subpack->name ?? '',
                $client->customer_id,
                $client->marketed_by,
                $client->deleted_at,
                $client->parmanent_discount,
                $client->required_cable,
                $client->ignoreMKCheck,
                $client->closed_at,
                $client->bandwidth_limit,
                $client->up_bandwidth,
                $client->down_bandwidth,
                $client->isStatic,
                $client->auto_deactive,
                $client->clientsinfo->clients_name ?? '',
                $client->clientsinfo->father_name ?? '',
                $client->clientsinfo->mother_name ?? '',
                $client->clientsinfo->flat_no ?? '',
                $client->clientsinfo->building_name ?? '',
                $client->clientsinfo->road_no ?? '',
                $client->clientsinfo->block_sector ?? '',
                $client->clientsinfo->area ?? '',
                $client->clientsinfo->district ?? '',
                $client->clientsinfo->thana ?? '',
                $client->clientsinfo->contact_no ?? '',
                $client->clientsinfo->national_id ?? '',
                $client->clientsinfo->email ?? '',
                $client->clientsinfo->passport_no ?? '',
                $client->clientsinfo->created_at ?? '',
                $client->clientsinfo->updated_at ?? '',
                $client->clientsinfo->owner_name ?? '',
                $client->clientsinfo->owner_number ?? '',
                $client->clientsinfo->olt_pon ?? '',
                $client->clientsinfo->otc ?? '',
                $client->clientsinfo->building_no ?? '',
                $client->clientsinfo->remarks ?? '',
                $client->clientsinfo->dob ?? '',
                $client->clientsinfo->cable_type ?? '',
                $client->clientsinfo->road_name ?? '',
                $client->clientsinfo->otc_due ?? '',
                $client->clientsinfo->profilePicture ?? '',
                $client->clientsinfo->other_contact ?? '',
                $client->clientsinfo->box ?? '',
                $client->clientsinfo->joinDate ?? '',
                $client->clientsinfo->client_latitude ?? '',
                $client->clientsinfo->client_longitude ?? '',
                $client->clientsinfo->picture ?? '',
                $client->clientsinfo->client_door ?? '',
                $client->clientsinfo->cat_type ?? '',
                $client->clientsinfo->cat_length ?? '',
                $client->clientsinfo->olt_no ?? '',
                $client->clientsinfo->pon_port ?? '',
                $client->clientsinfo->onu_serial ?? '',
                $client->clientsinfo->customer_profile_picture ?? '',
                $client->clientsinfo->from_cable ?? '',
                $client->clientsinfo->to_cable ?? '',
                $client->clientsinfo->customer_agrement ?? '',
                $client->clientsinfo->cable_id ?? '',
                $client->clientsinfo->customer_package_name ?? '',
                $client->clientsinfo->btrc_package_bandwidth ?? '',
                $client->clientsinfo->from_cable2 ?? '',
                $client->clientsinfo->to_cable2 ?? '',
                $client->clientsinfo->source_name ?? '',
                $client->clientsinfo->division ?? '',
            ];
        }

        // dd($items);

        return collect($items);
    }
}
